/* jshint unused: true */
/* global parameters */

let aguila = require('common/aguila');
let objects = require('common/objects');
let icons = require('/agorum/roi/customers/agorum.icons/js/icons');
let userSettings = require('/agorum/roi/customers/agorum.composite/js/user-settings');
// let customView = require('/agorum/roi/customers/agorum.explorer/js/aguila/custom-view');

/**/
parameters.showDetails = true;
parameters.width = 1600;
parameters.height = 800;
parameters.roots = [8011695];
//parameters.initiallyVisibleDepth = 3;
// parameters.leafId = 2071967;
// $$.debug('main - parameters', parameters);
/**/

// check url request parameter
if (parameters.root) {
  // TODO: check ID, process list of IDs
  parameters.roots = [parameters.root];
}
if (parameters.depth) {
  parameters.initiallyVisibleDepth = parameters.depth;
}

let aon = {
  type: 'agorum.border',
  properties: ['id', 'selection', 'roots', 'displayName', 'sort', 'view'],
  docked: {
    top: {
      name: 'navigation',
      type: 'agorum.explorer.navigation',
      noHistory: parameters.noHistory,
    },
    west: {
      name: 'tree',
      type: 'agorum.explorer.tree',
      width: 300,
      border: true,
      initiallyVisibleDepth: parameters.initiallyVisibleDepth,
      config: parameters.config,
      roots: parameters.roots,
      leafId: parameters.leafId,
    },
    center: {
      name: 'container',
      type: 'agorum.single',
      items: [
        {
          name: 'list',
          type: 'agorum.explorer.list',
          border: true,
          external: parameters.external,
        },
      ],
    },
  },
  // default values
  width: parameters.width || 1600,
  height: parameters.height || 800,
};

if (parameters.showDetails) {
  aon.docked.east = {
    type: 'agorum.composite.details',
    name: 'details',
    border: true,
    width: 550,
  };
}

let widget = aguila.create(aon);

let navigation = widget.down('navigation');
let tree = widget.down('tree');
let list = widget.down('list');

userSettings.application(widget, 'agorum.explorer');

// initialize custom views
// customView.init(widget);

// forward roots changes
widget.on('rootsChanged', roots => {
  tree.roots = roots;
  navigation.reset();
});

// forward menu override registration
widget.addMethod(
  'menuOverride',
  override => navigation.menuOverride(override) && tree.menuOverride(override) && list.menuOverride(override)
);

// synchronize our ID with the tree widget's leaf ID
widget.on('idChanged', id => (tree.leafId = id));
tree.on('leafIdChanged', id => (widget.id = id));

// synchronize the currently displayed folder's ID across all widgets
navigation.on('idChanged', id => (tree.id = list.id = id));
tree.on('idChanged', id => (navigation.id = list.id = id));
list.on('idChanged', id => (navigation.id = tree.id = id));

// clear list selection on folder change
list.on('idChanged', () => (list.selection = []));

// clear list selection on tree node click
tree.on('nodeClicked', () => list.selection && list.selection.length > 0 && (list.selection = []));

// replicate the list's selection
widget.on('selectionChanged', selection => (list.selection = selection));
list.on('selectionChanged', selection => (widget.selection = selection));

// replicate the loading state
list.on('loadingChanged', loading => (navigation.loading = loading));

// replicate sort property
widget.on('sortChanged', sort => (list.sort = sort));
list.on('sortChanged', sort => (widget.sort = sort));

// display details of currently selected object or current folder if no selection
let details;

if (parameters.showDetails) {
  details = widget.down('details');
  let updateDetails = () => {
    let id = (widget.selection || [])[0];
    let parentId = tree.id || widget.id;

    if (id) {
      details.id = parentId ? parentId + '|' + id : id;
    } else {
      details.id = parentId;
    }
  };

  widget.on('idChanged', updateDetails);
  widget.on('selectionChanged', updateDetails);
}

// update widget property displayName and form properties title and icon according to the currently displayed folder
widget.on('idChanged', id =>
  aguila
    .fork(() => {
      let object = objects.tryFind(id);

      return object ? [object.displayName, icons.object(object)] : [];
    })
    .then(([displayName, icon]) => {
      // update our displayName property
      widget.displayName = displayName;

      // update form properties only in "standalone" mode
      let form = widget.form;

      if (form && form.instanceId === widget.container.instanceId) {
        form.title = displayName;
        form.icon = icon && icons.cls(icon.expanded || icon.icon);
      }
    })
);

setImmediate(() => {
  let state = userSettings.bucket(widget);

  if (details) {
    // remember details width
    state.persist('main.details.width', details, 'width');
  }

  // remember tree width
  state.persist('main.tree.width', tree, 'width');

  // widget.down('tree').roots = parameters.roots;
});

widget;
